#version 120

uniform sampler2D sampler0;
uniform ivec4 viewport;
uniform int postprocessID;

	vec2 tc_offset[9];

//apply postprocess filter for textured polygon

//blur filter
vec4 Blur(vec4[9] sample)
{
	vec4 v =  (sample[0] + 2.0*sample[1] + sample[2] 
	      	   + 2.0*sample[3] + sample[4] + 2.0*sample[5] 
		       + sample[6] + 2.0*sample[7] + sample[8])/13.0;
    v.a = 1.0;
	return v;
}

//laplacian edge-detect filter
vec4 LaplacianEdgeDetection(vec4[9] sample)
{
	vec4 v =  sample[1] + sample[3] + sample[5] + sample[7] - (4.0*sample[4]);
    
    v.a = 1.0;
	return v;
}

//grayscale
vec4 Grayscale(vec4 sample)
{
    vec4 v;
    v = vec4(vec3(dot(sample.rgb, vec3(0.3, 0.59, 0.11))), 1.0);
    return v;
}

//inverse
vec4 Inverse(vec4 sample)
{
    vec4 v;
    v = vec4(vec3(1.0) - sample.rgb, 1.0);
    return v;
}

//Roberts Cross-gradient
vec4 Sepia(vec4 sample)
{
    vec4 v;
    mat3 m = mat3(0.393, 0.349, 0.272, 0.769, 0.686, 0.534, 0.189, 0.168, 0.131); 
    v = vec4(m * sample.rgb, sample.a);
    return v;
}


//Roberts Cross-Gradient
vec4 Rob(vec4[9] sample)
{
    vec4 v;
    vec3 bw = vec3(0.3, 0.59, 0.11);
    float c1 = dot(bw, sample[4].rgb);
    float c2 = dot(bw, sample[6].rgb);
    float c3 = dot(bw, sample[8].rgb);
    c2 = abs(c1 - c2);
    c3 = abs(c1 - c3);
    c1 = c2+c3;

    v = vec4(vec3(dot(sample[4].rgb*c1, bw)), sample[4].a);
    return v;
}

//cartoon 
vec4 Cartoon(vec4[9] sample)
{
   vec4 v = vec4(0);
    float w[9] = float[9](0.0, 1.0, 0.0
                         , 1.0, -4.0, 1.0
                         , 0.0, 1.0, 0.0); 

       
   v = sample[1] + sample[3] - 4.0*sample[4] + sample[5] + sample[7];
   float intensity = dot(v.rgb, vec3(0.3, 0.59, 0.11) );
   if(intensity > .2) 
      v = vec4(0,0,0,1);
   else
   {
      float colorNr = 5.0;
      vec3 iResult = floor(sample[4].rgb*colorNr);
      v = vec4(iResult/colorNr, sample[4].a);
   }
   return v;
}

//fill the sorce texture samples 3x3 matrix
void FillSamples(inout vec4[9] sample, float factor)
{
    float xmax = 1.0/float(viewport[2]);
	float xmin = -xmax;
	float ymax = 1.0/float(viewport[3]);
	float ymin = -ymax;
	tc_offset[0].x = tc_offset[3].x = tc_offset[6].x = xmin;
	tc_offset[6].y = tc_offset[7].y = tc_offset[8].y = ymax;
	tc_offset[0].y = tc_offset[1].y = tc_offset[2].y = ymin;
	tc_offset[2].x = tc_offset[5].x = tc_offset[8].x = xmax;
	tc_offset[1].x = tc_offset[3].y = tc_offset[4].x = tc_offset[4].y = tc_offset[5].y = tc_offset[7].x = 0.0;		
	
    for(int i = 0; i < 9; i++)    
	{
		sample[i] = texture2D(sampler0, gl_TexCoord[0].st + tc_offset[i] * factor);
	}
}

void main()
{
	vec4  sample[9];
	    
	vec4 v;

    gl_FragColor = gl_Color;  
 
    if(postprocessID == 1)
    {
        sample[4] = texture2D(sampler0, gl_TexCoord[0].st);
        v = Grayscale(sample[4]);
    }
    else if(postprocessID == 2)
    {
        FillSamples(sample, 1.0);
        v = LaplacianEdgeDetection(sample);
    }
    else if(postprocessID == 3)
    {
        FillSamples(sample, 2.0);
        v = Blur(sample);
    }
    else if(postprocessID == 4)
    {
        sample[4] = texture2D(sampler0, gl_TexCoord[0].st);
        v = Inverse(sample[4]);
    }
	else if(postprocessID == 5)
    {
        sample[4] = texture2D(sampler0, gl_TexCoord[0].st);
        v = Sepia(sample[4]);
    }
    else if(postprocessID == 6)
    {
        FillSamples(sample, 1.0);
        v = Rob(sample);
    }
	else if(postprocessID == 7)
    {
        FillSamples(sample, 4.0);
        v = Cartoon(sample);
    }	

    gl_FragColor = v;  
}
